:: ==== Auto-elevate to Administrator ====
@echo off
>nul 2>&1 net session
if %errorlevel% neq 0 (
	 echo Requesting administrative privileges...
	 powershell -Command "Start-Process '%~f0' -Verb RunAs"
	 exit /b
)

setlocal enabledelayedexpansion
title PeriService_Installer
echo.
echo ==========================================
echo PeriService - Automated Install / Update
echo ==========================================

:: ========= CONFIGURATION =========

set "ZIP_FILE=Asset.zip"
set "APP_NAME=PeriServiceSetup"
set "SERVICE_NAME=PinpadService"
set "SERVICE_CONFIG_DIR=C:\TCSKioskPinpad\"
set "TEMP_INSTALL_DIR=%TEMP%\periservice"
REM Names of the EXE and MSI INSIDE the ZIP after extraction
set "EXE_FILE=setup.exe"

REM Silent args
set "EXE_SILENT_ARGS=/qn /norestart"

REM MSI log file location
set "LOG_FILE=%~dp0install-msi.log"

:: ========= END CONFIGURATION =========

echo.
echo Initializing....

REM Clean previous temp folder if present
if exist "%TEMP_INSTALL_DIR%" (
	 REM echo Removing old temp folder "%TEMP_INSTALL_DIR%"...
	 rmdir /S /Q "%TEMP_INSTALL_DIR%"
)

REM echo Creating temp folder "%TEMP_INSTALL_DIR%"...
mkdir "%TEMP_INSTALL_DIR%" >nul 2>&1

REM Check for the zip
if not exist "%~dp0%ZIP_FILE%" (
	 echo [ERROR] Zip file not found:
	 echo "%~dp0%ZIP_FILE%"
	 exit
	 REM exit /b 10
)

REM echo Extracting "%ZIP_FILE%" to "%TEMP_INSTALL_DIR%"...
powershell -Command "Expand-Archive -LiteralPath '%~dp0%ZIP_FILE%' -DestinationPath '%TEMP_INSTALL_DIR%' -Force"
if %errorlevel% neq 0 (
	 echo [ERROR] Failed to extract installer zip.
	 exit
	 REM exit /b 11
)

echo.
echo ==========================================
echo 1) Uninstalling existing application (if any)
echo ==========================================

set "FOUND_MSI=0"
for /f "skip=1 tokens=1,*" %%A in ('
	 wmic product where "Name like '%%%APP_NAME%%%'" get Name 2^>NUL
') do (
	 if not "%%A"=="" (
	 set "FOUND_MSI=1"
	 echo Found installed product: %%A %%B
	 echo Uninstalling silently via WMIC...
	 wmic product where "Name like '%%%APP_NAME%%%'" call uninstall /nointeractive >nul 2>&1
	 echo WMIC uninstall return code: !ERRORLEVEL!
	 goto :after_uninstall
	 )
)

if "!FOUND_MSI!"=="0" (
	 echo No MSI product with name "%APP_NAME%" found. Skipping MSI uninstall.
)

:after_uninstall

echo.
echo ==========================================
echo 2) Stopping and deleting Windows service (if present)
echo ==========================================

sc query "%SERVICE_NAME%" >nul 2>&1
if %errorlevel%==0 (
	 echo Service "%SERVICE_NAME%" exists, attempting to stop...
	 sc stop "%SERVICE_NAME%" >nul 2>&1
	 timeout /t 10 /nobreak >nul 2>&1

	 REM Extra kill safeguard
	 taskkill /F /FI "SERVICES eq %SERVICE_NAME%" >nul 2>&1

	 echo Deleting service "%SERVICE_NAME%"...
	 sc delete "%SERVICE_NAME%" >nul 2>&1
	 echo Service delete command issued.
) else (
	 echo Service "%SERVICE_NAME%" not found. Skipping service removal.
)

REM Wait a moment
timeout /t 5 /nobreak >nul

echo.
echo ==========================================
echo 2b) Deleting service configuration folder (if present)
echo ==========================================

if exist "%SERVICE_CONFIG_DIR%" (
	 echo Removing folder configuration files...
	 rmdir /S /Q "%SERVICE_CONFIG_DIR%"
	 if %errorlevel%==0 (
	 	 echo Configuration folder deleted successfully.
	 ) else (
	 	 echo [WARNING] Failed to delete configuration folder. Check permissions or file locks.
	 )
) else (
	 echo Configuration folder not found. Skipping deletion.
)

echo.
echo ==========================================
echo 3) Installing new version
echo ==========================================

if exist "%TEMP_INSTALL_DIR%\%EXE_FILE%" (
	echo Installing from EXE
	echo Silent args passed through to MSI: %EXE_SILENT_ARGS%
	"%TEMP_INSTALL_DIR%\%EXE_FILE%" %EXE_SILENT_ARGS% /L*v "%LOG_FILE%"
	set "RC=%ERRORLEVEL%"
	echo EXE installer return code: !RC!
) else (
	echo [ERROR] EXE installer not found.
)

echo.
echo ==========================================
echo 4) Starting the new service
echo ==========================================

timeout /t 5 /nobreak >nul 2>&1
sc start "%SERVICE_NAME%" >nul 2>&1
timeout /t 5 /nobreak >nul 2>&1

sc query "%SERVICE_NAME%" | findstr /i "RUNNING" >nul
if %errorlevel%==0 (
	 echo Service "%SERVICE_NAME%" started successfully.
) else (
	 echo [WARNING] Service "%SERVICE_NAME%" did not report RUNNING state.
	 echo Please check the Windows Services console or application logs.
)

echo.
echo ==========================================
echo 5) Cleaning up temp installer folder
echo ==========================================

if exist "%TEMP_INSTALL_DIR%" (
	 echo Removing temp files... 
	 REM echo "%TEMP_INSTALL_DIR%"
	 rmdir /S /Q "%TEMP_INSTALL_DIR%"
) else (
	 echo Temp folder not found. Nothing to clean.
)

echo.
echo ==========================================
echo All steps completed.
echo ==========================================
exit

endlocal
exit /b %RC%